% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F022.run.imput.R
\name{run.impute}
\alias{run.impute}
\title{Impute the main data}
\usage{
run.impute(x = NULL, genes = "all_genes", k = 10, alpha = 15,
  t = "auto", npca = 100, init = NULL, t.max = 20,
  knn.dist.method = "euclidean", verbose = 1, n.jobs = 1,
  seed = NULL)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{genes}{character or integer vector, default: NULL vector of column names or column indices for which to return smoothed data If 'all_genes' or NULL, the entire smoothed matrix is returned}

\item{k}{int, optional, default: 10 number of nearest neighbors on which to build kernel}

\item{alpha}{int, optional, default: 15 sets decay rate of kernel tails. If NULL, alpha decaying kernel is not used}

\item{t}{int, optional, default: 'auto' power to which the diffusion operator is powered sets the level of diffusion. If 'auto', t is selected according to the Procrustes disparity of the diffused data.'}

\item{npca}{number of PCA components that should be used; default: 100.}

\item{init}{magic object, optional object to use for initialization. Avoids recomputing intermediate steps if parameters are the same.}

\item{t.max}{int, optional, default: 20 Maximum value of t to test for automatic t selection.}

\item{knn.dist.method}{string, optional, default: 'euclidean'. recommended values: 'euclidean', 'cosine' Any metric from 'scipy.spatial.distance' can be used distance metric for building kNN graph.}

\item{verbose}{'int' or 'boolean', optional (default : 1) If 'TRUE' or '> 0', message verbose updates.}

\item{n.jobs}{'int', optional (default: 1) The number of jobs to use for the computation. If -1 all CPUs are used. If 1 is given, no parallel computing code is used at all, which is useful for debugging. For n_jobs below -1, (n.cpus + 1 + n.jobs) are used. Thus for n_jobs = -2, all CPUs but one are used}

\item{seed}{int or 'NULL', random state (default: 'NULL')}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and runs imputation on the main data. MAGIC as one of the methods: Markov Affinity-based Graph Imputation of Cells (MAGIC) is an algorithm for denoising and transcript recover of single cells applied to single-cell RNA sequencing data, as described in van Dijk et al, 2018.
}
