% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F028.findMarkers.R
\name{findMarkers}
\alias{findMarkers}
\title{Find marker genes for each cluster}
\usage{
findMarkers(x = NULL, fold.change = 2, padjval = 0.1,
  Inf.FCs = FALSE, uniq = FALSE, positive = TRUE)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{fold.change}{A number that designates the minimum fold change for out put, default = 2.}

\item{padjval}{Minimum adjusted p value for out put, default = 0.1.}

\item{Inf.FCs}{If set to FALSE the infinite fold changes would be filtered from out put, default = FALSE.}

\item{uniq}{If set to TRUE only genes that are a marker for only one cluster would be in the out put, default = TRUE.}

\item{positive}{If set to FALSE both the up regulated (positive) and down regulated (negative) markers would be in the out put, default = FALSE.}
}
\value{
An object of class iCellR
}
\description{
This function takes an object of class iCellR and performs differential expression (DE) analysis to find marker genes for each cluster.
}
\examples{
marker.genes <- findMarkers(demo.obj,fold.change = 2,padjval = 0.1,uniq = TRUE)

head(marker.genes)
}
