% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{methods}
\name{sparsity}
\alias{sparsity}
\alias{sparsity,Cube-method}
\title{Calculates the sparsity of a given cube.}
\usage{
sparsity(x)
}
\arguments{
\item{x}{The \code{Cube} object for which the sparsity will be computed.}
}
\value{
Sparsity value
}
\description{
Calculates the sparsity of the actual view of a \code{Cube} object. All added selections and
aggregations will be regarded. Note that selection criteria will be applied before
aggregating the data.
}
\examples{

data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
sparsity(cube)

}
\seealso{
\code{\link{importance}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\keyword{methods}
