% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrDEA.R
\name{wrDEA}
\alias{wrDEA}
\title{Estimation of DEA efficiency scores with linear input or output orientation and trade-off weight restrictions}
\usage{
wrDEA(
  X,
  Y,
  ORIENTATION = "out",
  RTS = "vrs",
  WR = NULL,
  XREF = NULL,
  YREF = NULL,
  SUPEREFF = FALSE,
  SLACK = FALSE,
  ECONOMIC = FALSE
)
}
\arguments{
\item{X}{Vector, matrix or dataframe with DMUs as rows and inputs as columns}

\item{Y}{Vector, matrix or dataframe with DMUs as rows and outputs as columns}

\item{ORIENTATION}{Character string indicating the orientation of the DEA model, e.g. "in", "out"}

\item{RTS}{Character string indicating the returns-to-scale, e.g. "crs", "vrs", "ndrs", "nirs", "fdh"}

\item{WR}{Matrix with one row per homogeneous linear weight restriction in standard form. The columns are 
ncol(WR) = ncol(Y) + ncol(X). Hence the first ncol(Y) columns are the restrictions on outputs and the last ncol(X) columns are the 
restrictions on inputs.}

\item{XREF}{Vector, matrix or dataframe with firms defining the technology as rows and inputs as columns}

\item{YREF}{Vector, matrix or dataframe with firms defining the technology as rows and outputs as columns}

\item{SUPEREFF}{Boolean variable indicating whether super-efficiencies shall be estimated}

\item{SLACK}{Boolean variable indicating whether slack-based estimation should be applied}

\item{ECONOMIC}{Boolean variable indicating whether economic efficiency (cost or revenue) is estimated using trade-off weight restrictions. 
Therefore mus can be positive and negative when set to TRUE and you have a multi-stage optimization where
the first stage is the efficiency estimation and the second stage is the minimization of the mus. You have to
use single trade-off, hence a 1 to 1 substitution of either inputs or outputs given by the focus on
either cost or revenue efficiency. The data must be value data.}
}
\value{
A list object containing the following information:
\item{eff}{Are the estimated efficiency scores for the DMUs under observation stored 
in a vector with the length nrow(X).}
\item{lambdas}{Estimated values for the composition of the respective Benchmarks.
The lambdas are stored in a matrix with the dimensions nrow(X) x nrow(X), where
the row is the DMU under observation and the columns the peers used for the Benchmark. NOTE:
Lambdas are automatically slack optimized.}
\item{mus}{If WR != NULL, the estimated decision variables for the imposed weight restrictions
 are stored in a matrix with the dimensions nrow(X) x nrow(WR), where the rows are the DMUs and 
 columns the weight restrictions. If the values are positive, the WR is binding for the respective DMU.}
\item{slack}{If SLACK = TRUE, the slacks are estimated and stored in a matrix with the dimensions
nrow(X) x (ncol(X) + ncol(Y)). Showing the Slack of each DMU (row) for each input and output
(column).}
}
\description{
Linear DEA estimation including the possibility of trade-off weight restrictions,
external referencing, and super-efficiency scores. Furthermore, in a second stage slacks can be estimated.
The function returns efficiency scores and adjusted lambdas according to the imposed weight restrictions and slack estimation. Additionally, 
mus are returned if weight restrictions are imposed that highlight binding restrictions for DMUs and the absolute slack values 
if slack-based estimation is applied.
}
\examples{
X <- c(1,1,2,4,1.5,2,4,3)
Y <- c(1,2,4,4,0.5,2.5,3.5,4)

# Two weight restrictions in standard form first on output then input.
# The first WR shows the trade-off that inputs can be reduced by one unit
# which reduces outputs by four units. The second WR shows that outputs can 
# be increased by one unit when inputs are increased by four units.

WR <- matrix(c(-4,-1,1,4), nrow = 2, byrow = TRUE)

wrDEA(X, Y, ORIENTATION = "in", RTS="vrs", WR = WR)

# For an estimation just focusing on one DMU one can for example use 
# XREF and YREF to define the technology and then estimate the efficiency for 
# the DMU under observation (here DMU 1). Let's additionally estimate the slacks. 

wrDEA(X[1], Y[1], ORIENTATION = "in", RTS="vrs", XREF = X, YREF = Y, SLACK = TRUE, WR = WR)

}
\author{
Alexander Öttl
}
