% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_interpolate.R
\name{interpolate}
\alias{interpolate}
\title{Interpolation}
\usage{
interpolate(
  x,
  col_name,
  out_name = NULL,
  miss_table,
  threshold,
  method = "linear"
)
}
\arguments{
\item{x}{data frame with class \code{Date} or \code{POSIXct} in the first column and numeric
on the others.}

\item{col_name}{string with column name of the series to interpolate.}

\item{out_name}{optional. String with new column name. If you set it as \code{NULL}, the
function will overwrite the original data frame.}

\item{miss_table}{data frame with three columns: first and last date of interpolation
(first and second column respectively). The last and third column, is of class \code{numeric}
with the number of steps to interpolate. See \link{report_miss}.}

\item{threshold}{numeric variable with the maximum number of dates in which to apply
the interpolation.}

\item{method}{string with the interpolation method. In this version only
\code{'linear'} method is allowed.}
}
\value{
The same data frame but with interpolated values.
}
\description{
This function applies interpolation to fill in missing (or non-recorded) values.
}
\examples{

# read cuevas station file
path <- system.file('extdata', 'ianigla_cuevas.csv',
        package = 'hydrotoolbox')

cuevas <- read_ianigla(path = path)

# get the miss_table
miss_data <- report_miss(x = cuevas, col_name = 'Irradiancia')[[1]]

# apply interpolation function when gap is less than 3 hours
cuevas_interpo <- interpolate(x = cuevas,
                              col_name = 'Irradiancia',
                              out_name = 'kin_interpo',
                              miss_table = miss_data,
                              threshold = 3)

report_miss(x = cuevas_interpo,
            col_name = c('Irradiancia', 'kin_interpo'))


}
