% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_stations}
\alias{get_stations}
\title{Get stations data}
\usage{
get_stations(subdomain = c("kyy", "ypaat", "emy"))
}
\arguments{
\item{subdomain}{One of the subdomains of hydroscope.gr}
}
\value{
If \code{subdomain} is one of \code{"kyy"} (Ministry of Environment
and Energy), \code{"ypaat"} (Ministry of Rural Development and Food), or
\code{"emy"} (National Meteorological Service), returns a tidy dataframe with
stations' data from the corresponding database of hydroscope.gr. Otherwise
gives an error message.

The dataframe columns are:
\describe{
    \item{StationID}{The station's ID from the domain's database}
    \item{Name}{The station's name}
    \item{WaterDivisionID}{The station's Water Division ID, values: GR01 -
    GR14}
    \item{WaterBasin}{The station's Water Basin}
    \item{PoliticalDivision}{The station's Political Division}
    \item{Owner}{The station's owner}
    \item{Type}{The station's type}
}
}
\description{
\code{get_stations} returns a dataframe with data from the stations that
exist in a database of Hydroscope.
}
\note{
Stations' IDs might not be unique at the different databases records from the
different Hydroscope domains.

The Greek Water Divisions ID are:
\tabular{ll}{
\strong{Code}  \tab \strong{Name} \cr
GR01 \tab DYTIKE PELOPONNESOS \cr
GR02 \tab BOREIA PELOPONNESOS \cr
GR03 \tab ANATOLIKE PELOPONNESOS \cr
GR04 \tab DYTIKE STEREA ELLADA \cr
GR05 \tab EPEIROS  \cr
GR06 \tab ATTIKE  \cr
GR07 \tab ANATOLIKE STEREA ELLADA \cr
GR08 \tab THESSALIA  \cr
GR09 \tab DYTIKE MAKEDONIA  \cr
GR10 \tab KENTRIKE MAKEDONIA  \cr
GR11 \tab ANATOLIKE MAKEDONIA  \cr
GR12 \tab THRAKE  \cr
GR13 \tab KRETE  \cr
GR14 \tab NESOI AIGAIOU  \cr
}

The codes used in Owner variable are:
\tabular{ll}{
\strong{Code}  \tab \strong{Name} \cr
min_env \tab Ministry of Environment and Energy \cr
noa \tab National Observatory of Athens \cr
min_rur \tab  Ministry of Rural Development and Food\cr
prefec \tab Prefectures of Greece  \cr
emy \tab National Meteorological Service  \cr
dei \tab Public Power Corporation  \cr
}

The types used at station's type are:
\tabular{ll}{
\strong{Code}  \tab \strong{Description} \cr
meteo_station \tab Weather station \cr
stream_gauge \tab Gauging station  \cr
}
}
\examples{

# get stations' data from the Greek National Meteorological Service
emy_stations <- get_stations(subdomain = "emy")

\dontrun{
dei_stations <- get_stations(subdomain = "dei")
}

}
\references{
European Terrestrial Reference System 1989 (ETRS),
\url{http://bit.ly/2kJwFuf}

Greek Water Divisions,
\url{http://bit.ly/2kk0tOm}

Stations' data are retrieved from the Hydroscope's databases:
\itemize{
\item Ministry of Environment, Energy and Climate Change,
\url{http://kyy.hydroscope.gr}
\item Ministry of Rural Development and Food,
\url{http://ypaat.hydroscope.gr}
\item National Meteorological Service,
\url{http://emy.hydroscope.gr}
}
}
\author{
Konstantinos Vantas, \email{kon.vantas@gmail.com}
}
