% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg.R
\name{zygdist}
\alias{zygdist}
\title{Zygote dosage probabilities.}
\usage{
zygdist(alpha, G1, G2, ploidy)
}
\arguments{
\item{alpha}{A numeric vector containing the double reduction parameter(s).
This should be a
vector of length \code{floor(ploidy/4)} where \code{alpha[i]}
is the probability of exactly \code{i} pairs of IBDR alleles
being in the gamete. Note that \code{sum(alpha)} should be less than
1, as \code{1 - sum(alpha)} is the probability of no double reduction.}

\item{G1}{The dosage of parent 1. Should be an integer between \code{0}
and \code{ploidy}.}

\item{G2}{The dosage of parent 2. Should be an integer between \code{0}
and \code{ploidy}.}

\item{ploidy}{The ploidy of the species. This should be an even positive
integer.}
}
\value{
A vector of probabilities. The \code{i}th element is the
probability that the offspring will have dosage \code{i-1}.
}
\description{
Calculates the distribution of an offspring dosages given
parental dosages (\code{G1} and \code{G2}), the ploidy of the
species (\code{ploidy}), and the double reduction parameter
(\code{alpha}).
}
\examples{
zygdist(alpha = c(0.5, 0.1), G1 = 4, G2 = 5, ploidy = 8)

}
\author{
David Gerard
}
