% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbs_gl}
\alias{gibbs_gl}
\title{Gibbs sampler under random mating using genotype log-likelihoods.}
\usage{
gibbs_gl(
  gl,
  alpha,
  B = 10000L,
  T = 1000L,
  more = FALSE,
  lg = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{gl}{The matrix of genotype log-likelihoods. The columns index the
dosages and the rows index the individuals. \code{gl[i,j]} is the
genotype log-likelihood for individual i at dosage j. It is assumed
that natural log is used.}

\item{alpha}{Vector of hyperparameters for the gamete frequencies.
Should be length (x.length() - 1) / 2 + 1.}

\item{B}{The number of sampling iterations.}

\item{T}{The number of burn-in iterations.}

\item{more}{A logical. Should we also return posterior draws (\code{TRUE})
or not (\code{FALSE}).}

\item{lg}{Should we return the log marginal likelihood (true) or not
(false).}

\item{verbose}{A logical. Should we print the progress?}
}
\value{
A list with some or all of the following elements
\itemize{
\item{\code{mx}: The estimate of the marginal likelihood}
\item{\code{p_tilde}: The value of p used to evaluate the posterior density}.
\item{\code{p}: The samples of the gamete frequencies}
\item{\code{z}: The samples of the individual genotypes}
\item{\code{post}: The samples of the full conditionals of p_tilde.}
}
}
\description{
Gibbs sampler under random mating using genotype log-likelihoods.
}
\examples{
set.seed(1)
ploidy <- 8

## Simulate under the null
p <- stats::runif(ploidy / 2 + 1)
p <- p / sum(p)
q <- stats::convolve(p, rev(p), type = "open")
nvec <- c(stats::rmultinom(n = 1, size = 100, prob = q))
gl <- simgl(nvec)

gibbs_gl(gl = gl, alpha = rep(1, ploidy / 2 + 1), lg = TRUE)

}
\author{
David Gerard
}
