% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind-insert.R
\name{t.huxtable}
\alias{t.huxtable}
\title{Transpose a huxtable}
\usage{
\method{t}{huxtable}(x)
}
\arguments{
\item{x}{A huxtable.}
}
\value{
The transposed object.
}
\description{
Transpose a huxtable
}
\details{
Row and column spans of \code{x} will be swapped, as will column widths and row heights,
table width and height, and cell borders (bottom becomes right, etc.).
Other properties - in particular, alignment, vertical alignment and rotation - will be
preserved.
}
\examples{
ht <- huxtable(
        a = 1:3,
        b = letters[1:3],
        autoformat = FALSE
      )
bottom_border(ht)[3,] <- 1
ht
t(ht)

}
