% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-set-convenience.R
\name{merge_repeated_rows}
\alias{merge_repeated_rows}
\title{Merge repeated rows into multirow cells}
\usage{
merge_repeated_rows(ht, row, col)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specification.}

\item{col}{A column specification.}
}
\value{
The modified huxtable.
}
\description{
Merge repeated rows into multirow cells
}
\details{
Repeated rows in each column are merged into cells with
\code{rowspan > 1}.

If \code{row} contains gaps, results may be unexpected (and a warning is given).
}
\examples{
ht <- as_hux(jams[c(1, 2, 2, 3, 3, 4), ])
ht <- add_columns(ht, c("Sugar", "30\%", "40\%", "30\%", "40\%", "30\%"),
      after = 1)
ht
merge_repeated_rows(ht)
merge_repeated_rows(ht, everywhere, "Type")
}
\seealso{
merge_cells
}
