% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{number_format}
\alias{number_format}
\alias{number_format<-}
\alias{set_number_format}
\title{Number format}
\usage{
number_format(ht)
number_format(ht) <- value
set_number_format(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}

\item{value}{A character or integer vector, or a list containing a function, or \code{NA}. Note
that setting to \code{NA} does not reset to the default.}
}
\value{
For \code{number_format}, the \code{number_format} property.
For \code{set_number_format}, the \code{ht} object.
}
\description{
Functions to get or set the \emph{number format} property of huxtable cells.
}
\details{
Number formatting is applied to any parts of cells that look like numbers (defined as an optional minus sign,
followed by
numerals, followed by an optional decimal point and further numerals). The exception is exponents in
scientific notation; huxtable attempts to detect and ignore these.

If \code{value} is
\itemize{
\item numeric, numbers will be rounded to that many decimal places;
\item character, it will be taken as an argument to \code{\link[=sprintf]{sprintf()}};
\item a function, the function will be applied to the numbers;
\item \code{NA}, then numbers will not be formatted (except maybe by conversion with \code{as.character}).
}

Note that if your cells are of type numeric, a number format of \code{NA} doesn't guarantee you get
back what you typed in, since R's default conversion may apply scientific notation and
rounding.

The default value is "\%.3g", which rounds numbers if they have more than 3 significant
digits, and which may use scientific notation for large numbers.

To set number_format to a function, enclose the function in \code{list}. The function should
take one argument and return a string.

Versions of huxtable before 2.0.0 applied \code{number_format} only to cells that looked like
numbers in their entirety. The default value was "\%5.2f".
}
\examples{
ht <- huxtable(
  number_format = c("Default", "NA", "2", "\\"\%5.2f\\"", "Pretty", "Sign"),
  a = rep(1000, 6),
  b = rep(1000.005, 6),
  c = rep(0.0001, 6),
  d = rep(-1, 6),
  e = rep("3.2 (s.e. 1.4)", 6),
  add_colnames = TRUE
)
number_format(ht)[3, -1] <- NA
number_format(ht)[4, -1] <- 2
number_format(ht)[5, -1] <- '\%5.2f'
number_format(ht)[6, -1] <- list(function(x) prettyNum(x, big.mark = ',', scientific = FALSE))
number_format(ht)[7, -1] <- list(function(x) if(x>0) '+' else '-')
right_border(ht) <- 1
bottom_border(ht)[1, ] <- 1
ht

ht_bands <- huxtable("10000 Maniacs", autoformat = FALSE)
# probably not what you want:
ht_bands
number_format(ht_bands) <- NA
ht_bands
# alternatively:
huxtable("10000 Maniacs", autoformat = TRUE)

ht <- huxtable(a = 1:3, b = 3:1)
set_number_format(ht, 2)
set_number_format(ht, 1:2, 1, 2)
set_number_format(ht, 1:2, 1:2, c(2, 3), byrow = TRUE)
set_number_format(ht, where(ht == 1), 2)
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{font}}, \code{\link{na_string}},
  \code{\link{text_color}}
}
\concept{formatting functions}
