% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Workbook.R
\name{as_Workbook}
\alias{as_Workbook}
\alias{as_Workbook.huxtable}
\title{Convert a huxtable for Excel}
\usage{
as_Workbook(ht, ...)

\method{as_Workbook}{huxtable}(ht, Workbook = NULL, sheet = "Sheet 1",
  write_caption = TRUE, ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{...}{Not used.}

\item{Workbook}{An existing \code{Workbook} object. By default, a new workbook will be created.}

\item{sheet}{Name for the worksheet where the huxtable will be created.}

\item{write_caption}{If \code{TRUE}, print any caption in the row above or below the table.}
}
\value{
An object of class \code{Workbook}.
}
\description{
If the \code{openxlsx} package is installed, Huxtables can be converted to
\code{\link[openxlsx:openxlsx]{openxlsx::openxlsx()}} Worbook objects, for use in Excel documents.
}
\details{
Use \code{\link[openxlsx:saveWorkbook]{openxlsx::saveWorkbook()}} to save the resulting object to an Excel file.

Properties are supported with the following exceptions:
\itemize{
\item Non-numeric column widths and row heights, table width and height.
\item Decimal padding.
\item Cell padding.
\item Table position.
}

Huxtable tries to guess appropriate widths and height for rows and columns; numeric \code{\link[=width]{width()}} and
\code{\link[=height]{height()}} are treated as scaling factors.

Contents are only stored as numbers if a whole column is numeric as defined by \code{\link[=is_a_number]{is_a_number()}};
otherwise they are stored as text.
}
\examples{
ht <- hux(a = 1:3, b = 1:3)
wb <- as_Workbook(ht)
\dontrun{
openxlsx::saveWorkbook(wb, "my-excel-file.xlsx")
}
}
