% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_firstNA.R
\name{which_firstNA}
\alias{which_firstNA}
\alias{which_lastNA}
\title{First/last position of missing values}
\usage{
which_firstNA(x)

which_lastNA(x)
}
\arguments{
\item{x}{An atomic vector.}
}
\value{
The position of the first/last missing value in \code{x}.
}
\description{
Introduced in \code{v 1.6.0}
}
\examples{
N <- 1e8
N <- 1e6  # for CRAN etc
x <- c(1:1e5, NA, integer(N))
bench_system_time(which.max(is.na(x))) # 123ms
bench_system_time(Position(is.na, x))  #  22ms
bench_system_time(which_firstNA(x))    #  <1ms
}
