% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_isna.R
\name{sum_isna}
\alias{sum_isna}
\title{Number of missing values}
\usage{
sum_isna(x, do_anyNA = TRUE, nThread = getOption("hutilscpp.nThread", 1L))
}
\arguments{
\item{x}{An atomic vector.}

\item{do_anyNA}{Should \code{anyNA(x)} be executed before an attempt to
count the \code{NA}'s in \code{x} one-by-one? By default, set to \code{TRUE},
since it is generally quicker. It will only be slower when \code{NA} is rare
and occurs late in \code{x}.

Ignored silently if \code{nThread != 1}.}

\item{nThread}{\describe{
\item{\code{nThread}}{Number of threads to use.}
}}
}
\description{
The count of missing values in an atomic vector, equivalent to
to \code{sum(is.na(x))}.
}
\examples{
sum_isna(c(1:5, NA))
sum_isna(c(NaN, NA))  # 2 from v0.4.0 (Sep 2020)
}
