% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{in.window}
\alias{in.window}
\title{Select all ranges lying within a chromosome window}
\usage{
in.window(ranged, chr, pos, full.overlap = F, unit = c("b", "kb", "mb",
  "gb"), rmv.dup = FALSE)
}
\arguments{
\item{ranged}{GRanges or RangedData object}

\item{chr}{a chromosome, e.g, 1,2,3,...,22,X,Y,XY,MT or however chromosomes are 
annotated in 'ranged'}

\item{pos}{a numeric range (length 2), with a start (minima) and end (maxima), specifying
the window on the chromosome to select ranges from, base-pair units are specified by 'unit'.}

\item{full.overlap}{logical, the default is to return objects with ANY overlap with the window,
whereas setting this as TRUE, will only return those that fully overlap}

\item{unit}{the unit of base-pairs that 'pos' is using, eg, "b", "kb", "mb", "gb"}

\item{rmv.dup}{logical, whether to remove duplicate ranges from the return result. The default
is not to remove duplicates.}
}
\value{
an object of the same type as 'ranged', but only containing the rows that
were within the specified bounds
}
\description{
Input a ranged object (ie., GRanges or RangedData) and this function will
return the subset from chromosome 'chr' and within the base-pair range specified
by 'pos', in units of 'unit'. By default ranges with ANY overlap are returned, but
it can be specified that it must be full overlap. Duplicates can be removed.
}
\examples{
require(GenomicRanges)
iG <- get.immunog.locs()[2,] # select the 2nd iG region
ciG <- chrm(iG)  #  get the chromosome
posiG <- c(start(iG),end(iG)) # get the region start and end
rr <- rranges(10000) # create a large random GRanges object
in.window(rr,chr=ciG,pos=posiG) # set with ANY overlap of iG
in.window(rr,chr=ciG,pos=posiG,TRUE) # set with FULL overlap of iG
in.window(rr,chr=6,pos=c(25,35),unit="mb") # look between 25 - 35 MB on chr6 [ie, MHC]
}

