% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content-type.R
\name{resp_check_content_type}
\alias{resp_check_content_type}
\title{Check the content type of a response}
\usage{
resp_check_content_type(
  resp,
  valid_types = NULL,
  valid_suffix = NULL,
  check_type = TRUE,
  call = caller_env()
)
}
\arguments{
\item{resp}{A httr2 \link{response} object, created by \code{\link[=req_perform]{req_perform()}}.}

\item{valid_types}{A character vector of valid MIME types. Should only
be specified with \code{type/subtype}.}

\item{valid_suffix}{A string given an "structured media type" suffix.}

\item{check_type}{Should the type actually be checked? Provided as a
convenience for when using this function inside \verb{resp_body_*} helpers.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
Called for its side-effect; erroring if the response does not
have the expected content type.
}
\description{
A different content type than expected often leads to an error in parsing
the response body. This function checks that the content type of the response
is as expected and fails otherwise.
}
\examples{
resp <- response(headers = list(`content-type` = "application/json"))
resp_check_content_type(resp, "application/json")
try(resp_check_content_type(resp, "application/xml"))

# `types` can also specify multiple valid types
resp_check_content_type(resp, c("application/xml", "application/json"))
}
