% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-cookies.R
\name{req_cookie_preserve}
\alias{req_cookie_preserve}
\alias{req_cookies_set}
\title{Set and preserve cookies}
\usage{
req_cookie_preserve(req, path)

req_cookies_set(req, ...)
}
\arguments{
\item{req}{A httr2 \link{request} object.}

\item{path}{A path to a file where cookies will be read from before and updated after the request.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>
Name-value pairs that define query parameters. Each value must be
an atomic vector, which is automatically escaped. To opt-out of escaping,
wrap strings in \code{I()}.}
}
\description{
Use \code{req_cookie_set()} to set client side cookies that are sent to the
server.

By default, httr2 uses a clean slate for every request meaning that cookies
are not automatically preserved across requests. To preserve cookies, use
\code{req_cookie_preserve()} along with the path to cookie file that will be
read before and updated after each request.
}
\examples{
# Use `req_cookies_set()` to set client-side cookies
request(example_url()) |>
  req_cookies_set(a = 1, b = 1) |>
  req_dry_run()

# Use `req_cookie_preserve()` to preserve server-side cookies across requests
path <- tempfile()

# Set a server-side cookie
request(example_url()) |>
  req_cookie_preserve(path) |>
  req_template("/cookies/set/:name/:value", name = "chocolate", value = "chip") |>
  req_perform() |>
  resp_body_json()

# Set another sever-side cookie
request(example_url()) |>
  req_cookie_preserve(path) |>
  req_template("/cookies/set/:name/:value", name = "oatmeal", value = "raisin") |>
  req_perform() |>
  resp_body_json()

# Add a client side cookie
request(example_url()) |>
  req_url_path("/cookies/set") |>
  req_cookie_preserve(path) |>
  req_cookies_set(snicker = "doodle") |>
  req_perform() |>
  resp_body_json()

# The cookie path has a straightforward format
cat(readChar(path, nchars = 1e4))
}
