% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/http-verb.R
\name{VERB}
\alias{VERB}
\title{VERB a url.}
\usage{
VERB(verb, url = NULL, config = list(), ..., handle = NULL)
}
\arguments{
\item{verb}{Name of verb to use.}

\item{url}{the url of the page to retrieve}

\item{config}{Additional configuration settings such as http
authentication (\code{\link{authenticate}}), additional headers
(\code{\link{add_headers}}), cookies (\code{\link{set_cookies}}) etc.
See \code{\link{config}} for full details and list of helpers.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc,
passed on to \code{\link{modify_url}}. Unnamed parameters will be combined
with \code{\link{config}}.}

\item{handle}{The handle to use with this request. If not
  supplied, will be retrieved and reused from the \code{\link{handle_pool}}
  based on the scheme, hostname and port of the url. By default \pkg{httr}
  requests to the same scheme/host/port combo. This substantially reduces
  connection time, and ensures that cookies are maintained over multiple
  requests to the same host. See \code{\link{handle_pool}} for more
  details.}
}
\description{
Use an arbitrary verb.
}
\examples{
r <- VERB("PROPFIND", "http://svn.r-project.org/R/tags/",
  add_headers(depth = 1), verbose())
stop_for_status(r)
content(r)
}
\seealso{
Other http methods: \code{\link{BROWSE}};
  \code{\link{DELETE}}; \code{\link{GET}};
  \code{\link{HEAD}}
}

