% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mc_tk.R
\name{calc_mc_tk}
\alias{calc_mc_tk}
\title{Conduct multiple TK simulations using Monte Carlo}
\usage{
calc_mc_tk(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  samples = 1000,
  species = "Human",
  suppress.messages = FALSE,
  model = "pbtk",
  httkpop = TRUE,
  httkpop.dt = NULL,
  invitrouv = TRUE,
  calcrb2p = TRUE,
  censored.params = list(),
  vary.params = list(),
  return.samples = FALSE,
  tissue = NULL,
  output.units = "mg/L",
  solvemodel.arg.list = list(times = c(0, 0.25, 0.5, 0.75, 1, 1.5, 2, 2.5, 3, 4, 5)),
  Caco2.options = list(),
  invitro.mc.arg.list = NULL,
  httkpop.generate.arg.list = list(method = "direct resampling"),
  convert.httkpop.arg.list = NULL,
  parameterize.arg.list = NULL,
  return.all.sims = FALSE
)
}
\arguments{
\item{chem.cas}{Either the CAS number, parameters, or the chemical name must
be specified.}

\item{chem.name}{Either the chemical parameters, name, or the CAS number
must be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from parameterize_steadystate. Not used with
httkpop model.}

\item{samples}{Number of samples generated in calculating quantiles.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").  Species must be set to "Human" to run httkpop model.}

\item{suppress.messages}{Whether or not to suppress output message.}

\item{model}{Model used in calculation: 'pbtk' for the multiple compartment
model,'3compartment' for the three compartment model, '3compartmentss' for
the three compartment steady state model, and '1compartment' for one
compartment model.  This only applies when httkpop=TRUE and species="Human",
otherwise '3compartmentss' is used.}

\item{httkpop}{Whether or not to use population generator and sampler from
httkpop.  This is overwrites censored.params and vary.params and is only for
human physiology.  Species must also be set to 'Human'.}

\item{httkpop.dt}{A data table generated by \code{\link{httkpop_generate}}.
This defaults to NULL, in which case \code{\link{httkpop_generate}} is 
called to generate this table.}

\item{invitrouv}{Logical to indicate whether to include in vitro parameters
in uncertainty and variability analysis}

\item{calcrb2p}{Logical determining whether or not to recalculate the 
chemical ratio of blood to plasma}

\item{censored.params}{The parameters listed in censored.params are sampled
from a normal distribution that is censored for values less than the limit
of detection (specified separately for each parameter). This argument should
be a list of sub-lists. Each sublist is named for a parameter in
"parameters" and contains two elements: "CV" (coefficient of variation) and
"LOD" (limit of detection, below which parameter values are censored. New
values are sampled with mean equal to the value in "parameters" and standard
deviation equal to the mean times the CV.  Censored values are sampled on a
uniform distribution between 0 and the limit of detection. Not used with
httkpop model.}

\item{vary.params}{The parameters listed in vary.params are sampled from a
normal distribution that is truncated at zero. This argument should be a
list of coefficients of variation (CV) for the normal distribution. Each
entry in the list is named for a parameter in "parameters". New values are
sampled with mean equal to the value in "parameters" and standard deviation
equal to the mean times the CV. Not used with httkpop model.}

\item{return.samples}{Whether or not to return the vector containing the
samples from the simulation instead of the selected quantile.}

\item{tissue}{Desired steady state tissue conentration.}

\item{output.units}{Plasma concentration units, either uM or default mg/L.}

\item{solvemodel.arg.list}{Additional arguments ultimately passed to 
\code{\link{solve_model}}}

\item{Caco2.options}{A list of options to use when working with Caco2 apical to
basolateral data \code{Caco2.Pab}, default is Caco2.options = list(Caco2.default = 2,
Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.default sets the default value for 
Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}. Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.}

\item{invitro.mc.arg.list}{List of additional parameters passed to 
\code{\link{invitro_mc}}}

\item{httkpop.generate.arg.list}{Additional parameters passed to 
\code{\link{httkpop_generate}}.}

\item{convert.httkpop.arg.list}{Additional parameters passed to the 
convert_httkpop_* function for the model.}

\item{parameterize.arg.list}{Additional parameters passed to the 
parameterize_* function for the model.}

\item{return.all.sims}{Logical indicating whether to return the results
of all simulations, in addition to the default toxicokinetic statistics}
}
\value{
If return.all.sims == FALSE (default) a list with:
\item{means}{The mean concentration for each model compartment as a function
of time across the Monte Carlo simulation}
\item{sds}{The standard deviation for each model compartment as a function
of time across the Monte Carlo simulation}

If return.all.sums == TRUE then a list is returned with:
\item{stats}{The list of means and sds from return.all.sums=FALSE}
\item{sims}{The concentration vs. time results for each compartment for 
every (samples) set of parameters in the Monte Carlo simulation}
}
\description{
This function finds the analytical steady state plasma concentration(from
calc_analytic_css) using a monte carlo simulation (monte_carlo).
}
\details{
The Monte Carlo methods used here were recently updated and described by
Breen et al. (submitted).

All arguments after httkpop only apply if httkpop is set to TRUE and species
to "Human".

When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.

Tissue concentrations are calculated for the pbtk model with oral infusion
dosing.  All tissues other than gut, liver, and lung are the product of the
steady state plasma concentration and the tissue to plasma partition
coefficient.

The six sets of plausible \emph{in vitro-in vivo} extrpolation (IVIVE)
assumptions identified by Honda et al. (2019) 
(\doi{10.1371/journal.pone.0217564}) 
are: \tabular{lrrrr}{
\tab \emph{in vivo} Conc. \tab Metabolic Clearance \tab Bioactive Chemical
Conc. \tab TK Statistic Used* \cr Honda1 \tab Veinous (Plasma) \tab
Restrictive \tab Free \tab Mean Conc. \cr Honda2 \tab Veinous \tab
Restrictive \tab Free \tab Max Conc. \cr Honda3 \tab Veinous \tab
Non-restrictive \tab Total \tab Mean Conc. \cr Honda4 \tab Veinous \tab
Non-restrictive \tab Total \tab Max Conc. \cr Honda5 \tab Target Tissue \tab
Non-restrictive \tab Total \tab Mean Conc. \cr Honda6 \tab Target Tissue
\tab Non-restrictive \tab Total \tab Max Conc. \cr } *Assumption is
currently ignored because analytical steady-state solutions are currently
used by this function.
}
\examples{

\donttest{
NSAMP <- 50
chemname="Abamectin"
times<- c(0,0.25,0.5,0.75,1,1.5,2,2.5,3,4,5)
age.ranges <- seq(6,80,by=10)
forward <- NULL
for (age.lower in age.ranges)
{
  label <- paste("Ages ",age.lower,"-",age.lower+4,sep="")
  set.seed(1234)
  forward[[label]] <- calc_mc_tk(
                        chem.name=chemname,
                        samples=NSAMP,
                        httkpop.generate.arg.list=list(
                          method="d",
                          agelim_years = c(age.lower, age.lower+9)),
                        solvemodel.arg.list = list(
                          times=times))
}

}
}
\seealso{
\code{\link{create_mc_samples}}
}
\author{
John Wambaugh
}
\keyword{Monte-Carlo}
\keyword{dynamic}
\keyword{simulation}
