% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_hematocrit.R
\name{estimate_hematocrit}
\alias{estimate_hematocrit}
\title{Predict hematocrit using smoothing spline.}
\usage{
estimate_hematocrit(hcttmp_dt)
}
\arguments{
\item{hcttmp_dt}{A data.table with columns \code{age_years},
\code{age_months}, \code{gender}, \code{reth}.}
}
\value{
The same data.table with a \code{hematocrit} column added.
}
\description{
Using precalculated smoothing splines on NHANES log hematocrit vs. age in 
months (and KDE residuals) by gender and race/ethnicity, generate hematocrit 
values for individuals specified by age, gender, and race/ethnicity.
}
\references{
Ring, Caroline L., et al. "Identifying populations sensitive to 
environmental chemicals by simulating toxicokinetic variability." Environment 
International 106 (2017): 105-118
}
\author{
Caroline Ring
}
\keyword{httk-pop}
