% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ratioblood2plasma.R
\name{calc_rblood2plasma}
\alias{calc_rblood2plasma}
\title{Calculate the constant ratio of the blood concentration to the plasma
concentration.}
\usage{
calc_rblood2plasma(chem.cas = NULL, chem.name = NULL, params = NULL,
  hematocrit = NULL, default.to.human = F, species = "Human",
  adjusted.Funbound.plasma = T, suppress.messages = F)
}
\arguments{
\item{chem.cas}{Either the CAS number or the chemical name must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{params}{Parameters from parameterize_schmitt.}

\item{hematocrit}{Overwrites default hematocrit value in calculating
Rblood2plasma.}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{adjusted.Funbound.plasma}{Whether or not to use Funbound.plasma
adjustment.}

\item{suppress.messages}{Determine whether to display certain usage
feedback.}
}
\description{
This function calculates the constant ratio of the blood concentration to
the plasma concentration.
}
\details{
The red blood cell (RBC) parition coefficient as predicted by the Schmitt
(2008) method is used in the calculation. The value is calculated with the
equation: 1 - hematocrit + hematocrit * Krbc2pu * Funbound.plasma, summing
the red blood cell to plasma and plasma:plasma (equal to 1) partition
coefficients multiplied by their respective fractional volumes. When
species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data (hematocrit and temperature), but substitues
human fraction unbound and tissue volumes.
}
\examples{

calc_rblood2plasma(chem.name="Bisphenol A")
calc_rblood2plasma(chem.name="Bisphenol A",species="Rat")

}
\references{
Schmitt W. "General approach for the calculation of tissue to
plasma partition coefficients." Toxicology In Vitro, 22, 457-467 (2008).
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
