% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{onStaticRenderComplete}
\alias{onStaticRenderComplete}
\title{Execute JavaScript code after static render}
\usage{
onStaticRenderComplete(jsCode)
}
\arguments{
\item{jsCode}{A character vector containing JavaScript code. No R error will
be raised if the code is invalid, not even on JavaScript syntax errors.
However, the web browser will throw errors at runtime.}
}
\value{
An htmltools \code{\link[htmltools]{tags}$script} object.
}
\description{
Convenience function for wrapping a JavaScript code string with a
\code{<script>} tag and the boilerplate necessary to delay the execution of
the code until after the next time htmlwidgets completes rendering any
widgets that are in the page. This mechanism is designed for running code to
customize widget instances, which can't be done at page load time since the
widget instances will not have been created yet.
}
\details{
Each call to \code{onStaticRenderComplete} will result in at most one
invocation of the given code. In some edge cases in Shiny, it's possible for
static rendering to happen more than once (e.g. a \code{renderUI} that
contains static HTML widgets). \code{onStaticRenderComplete} calls only
schedule execution for the next static render operation.

The pure JavaScript equivalent of \code{onStaticRenderComplete} is
\code{HTMLWidgets.addPostRenderHandler(callback)}, where \code{callback} is a
JavaScript function that takes no arguments.
}
\examples{
\dontrun{
library(leaflet)
library(htmltools)
library(htmlwidgets)

page <- tagList(
  leaflet() \%>\% addTiles(),
  onStaticRenderComplete(
    "HTMLWidgets.find('.leaflet').setZoom(4);"
  )
)
print(page, browse = TRUE)
}

}

