% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{upper}
\alias{upper}
\title{Upper Bound}
\usage{
upper(kvars)
}
\arguments{
\item{kvars}{a named vector giving the upper bounds. The names should correspond to the names
of the covariates in the model matrix.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Set a upper bound on the coefficient of specific covariates.
}
\examples{
dat <- rhglm(100, c(1, 2, -3, 4, 5, -6))
constraints <- upper(c(x1 = 0, x4 = 1))
hglm(y ~ ., constraints = constraints, data = dat)
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_equal}()},
\code{\link{group_inout}()},
\code{\link{group_sparsity}()},
\code{\link{include}()},
\code{\link{k_max}()},
\code{\link{linear}()},
\code{\link{lower}()},
\code{\link{pairwise_sign_coherence}()},
\code{\link{rho_max}()},
\code{\link{sign_coherence}()}
}
\concept{Constraint-Constructors}
