% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoard_client.R
\name{hoard}
\alias{hoard}
\title{hoardr class}
\arguments{
\item{path}{(character) a path to cache files in. required}

\item{type}{(character) type of cache. One of user_cache_dir (default),
user_log_dir, user_data_dir, user_config_dir, site_data_dir,
site_config_dir. required}
}
\description{
hoardr class
}
\details{
\strong{Methods}
\describe{
\item{\code{cache_path_get()}}{
Get the cache path
}
\item{\code{cache_path_set()}}{
Set the cache path
}
\item{\code{list()}}{
List files in the directory (full file paths)
}
\item{\code{mkdir()}}{
Make the directory if doesn't exist already
}
\item{\code{delete()}}{
Delete files by name
}
\item{\code{delete_all()}}{
Delete all files
- force (\code{FALSE} as default)
}
\item{\code{details()}}{
Get file details
}
\item{\code{keys()}}{
Get SHA keys for all files
}
\item{\code{key()}}{
Get a SHA keys for a single file
}
\item{\code{files()}}{
Get all files as HoardFile objects
}
\item{\code{compress()}}{
Compress files into a zip file - leaving only the zip file
}
\item{\code{uncompress()}}{
Uncompress all files and remove zip file
}
}
}
\examples{
(x <- hoard())
x$cache_path_set("foobar")
x
x$path
x$cache_path_get()

# make the directory if doesn't exist already
x$mkdir()

# list files in dir
x$list()
cat(1:10000L, file = file.path(x$cache_path_get(), "foo.txt"))
x$list()

# cache details
x$details()

# delete files by name - we prepend the base path for you
x$delete("foo.txt")
x$list()
x$details()

# delete all files
cat("one\\ntwo\\nthree", file = file.path(x$cache_path_get(), "foo.txt"))
cat("asdfasdf asd fasdf", file = file.path(x$cache_path_get(), "bar.txt"))
x$delete_all()
x$list()

# make/get a key for a file
cat(1:10000L, file = file.path(x$cache_path_get(), "foo.txt"))
x$keys()
x$key(x$list()[1])

# as files
Map(function(z) z$exists(), x$files())

# compress and uncompress
x$compress()
x$uncompress()

# reset cache path
x$cache_path_set("stuffthings")
x
x$cache_path_get()
x$list()
}
