% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timer.R
\name{tmr_timer}
\alias{tmr_timer}
\alias{tmr_start}
\alias{tmr_stop}
\alias{tmr_elapsed}
\alias{tmr_reset}
\alias{tmr_is_started}
\alias{tmr_is_stopped}
\title{Use a tmr_timer}
\usage{
tmr_timer(seconds = 0, start = FALSE)

tmr_start(x)

tmr_stop(x)

tmr_elapsed(x)

tmr_reset(x, seconds = 0, start = FALSE)

tmr_is_started(x)

tmr_is_stopped(x)
}
\arguments{
\item{seconds}{A non-negative double scalar of the start time in seconds.}

\item{start}{A flag indicating whether to start the timer.}

\item{x}{A hms scalar.}
}
\description{
Use a tmr_timer
}
\section{Functions}{
\itemize{
\item \code{tmr_start}: Start Timer

\item \code{tmr_stop}: Stop Timer

\item \code{tmr_elapsed}: Elapsed Time

\item \code{tmr_reset}: Reset Timer

\item \code{tmr_is_started}: Is Started

\item \code{tmr_is_stopped}: Is Stopped
}}

\examples{
# create a new timer
t <- tmr_timer()

# no time has elapsed because the timer has not started
tmr_elapsed(t)

# start the timer
t <- tmr_start(t)

# get the time elapsed
# time elapsed is increasing because the timer is still running
Sys.sleep(1)
tmr_elapsed(t)
Sys.sleep(1)
tmr_elapsed(t)

# stop the timer
t <- tmr_stop(t)

# time elapsed is now fixed
tmr_elapsed(t)
Sys.sleep(1)
tmr_elapsed(t)

# reset the timer
t <- tmr_reset(t)
tmr_elapsed(t)
}
