% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{exp_sq}
\alias{exp_sq}
\title{Exponential squared correlation function}
\usage{
exp_sq(x, xp, hp)
}
\arguments{
\item{x}{A data.frame of rows corresponding to position vectors}

\item{xp}{A data.frame of rows corresponding to position vectors}

\item{hp}{The hyperparameter theta (correlation length)}
}
\value{
The exponential-squared correlation between x and xp.
}
\description{
For points \code{x}, \code{xp} and a correlation length \code{theta}, gives the exponent
of the squared distance between \code{x} and \code{xp}, weighted by \code{theta} squared.
}
\examples{
exp_sq(data.frame(a=1), data.frame(a=2), list(theta = 0.1))
#> 3.720076e-44
exp_sq(data.frame(a=1,b=2,c=-1),data.frame(a=1.5,b=2.9,c=-0.7), list(theta = 0.2))
#> 3.266131e-13
}
\references{
Rasmussen & Williams (2005) <ISBN: 9780262182539>
}
