% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasures.R
\name{knChooseReMeDI}
\alias{knChooseReMeDI}
\title{ReMeDI tuning parameter}
\usage{
knChooseReMeDI(
  pData,
  knMax = 10,
  tol = 0.05,
  size = 3,
  lower = 2,
  upper = 5,
  plot = FALSE
)
}
\arguments{
\item{pData}{\code{xts} or \code{data.table} containing the log-prices of the asset.}

\item{knMax}{max value of \code{kn} to be considered.}

\item{tol}{tolerance for the minimizing value. If \code{tol} is high, the algorithm will choose a lower optimal value.}

\item{size}{size of the local window.}

\item{lower}{lower boundary for the method if it fails to find an optimal value. If this is the case, the best kn between lower and upper is returned}

\item{upper}{upper boundary for the method if it fails to find an optimal value. If this is the case, the best kn between lower and upper is returned}

\item{plot}{logical whether to plot the errors.}
}
\value{
integer containing the optimal kn
}
\description{
Function to choose the tuning parameter, kn in ReMeDI estimation. 
The optimal parameter \code{kn} is the smallest value that where the criterion:
\deqn{
    SqErr(k_{n})^{n}_{t} = \left(\hat{R}^{n,k_{n}}_{t,0} - \hat{R}^{n,k_{n}}_{t,1} - \hat{R}^{n,k_{n}}_{t,2} + \hat{R}^{n,k_{n}}_{t,3} - \hat{R}^{n, k_{n}}_{t,l}\right)^{2}
}
is perceived to be zero. The tuning parameter \code{tol} can be set to choose the tolerance of the perception of 'close to zero', a higher tolerance will lead to a higher optimal value.
}
\details{
This is the algorithm B.2 in the appendix of the Li and Linton (2019) working paper.
}
\note{
We Thank Merrick Li for contributing his Matlab code for this estimator.
}
\examples{
optimalKn <- knChooseReMeDI(sampleTData[as.Date(DT) == "2018-01-02",],
                            knMax = 10, tol = 0.05, size = 3,
                            lower = 2, upper = 5, plot = TRUE)
optimalKn
\dontrun{
# We can also have a much larger search-space
optimalKn <- knChooseReMeDI(sampleTDataEurope,
                            knMax = 50, tol = 0.05,
                            size = 3, lower = 2, upper = 5, plot = TRUE)
optimalKn
}

}
\references{
Li, M. and Linton, O. (2019). A ReMeDI for microstructure noise. Cambridge Working Papers in Economics 1908.
}
\author{
Emil Sjoerup.
}
