% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidity_measures.R
\name{getLiquidityMeasures}
\alias{getLiquidityMeasures}
\title{Compute Liquidity Measure

Function returns an xts or data.table object containing 23 liquidity measures. Please see details below.

Note that this assumes a regular time grid. The Lee + Ready measure
uses two lags for the Tick Rule.}
\usage{
getLiquidityMeasures(tqdata, win = 300, type = NULL)
}
\arguments{
\item{tqdata}{A \code{data.table} or xts object as in the \pkg{highfrequency} merged
trades and quotes data (that is included).}

\item{win}{A windows length for the forward-prices used for \sQuote{realized}
spread}

\item{type}{Legacy option. Default is to return all liquidity measures.}
}
\value{
A modified (enlarged) \code{xts} or \code{data.table} with the new measures.
}
\description{
Compute Liquidity Measure

Function returns an xts or data.table object containing 23 liquidity measures. Please see details below.

Note that this assumes a regular time grid. The Lee + Ready measure
uses two lags for the Tick Rule.
}
\details{
NOTE: xts or data.table should only contain one day of observations

The respective liquidity measures are defined as follows:
  \itemize{
    \item{effectiveSpread}{
    \deqn{
     \mbox{effective spread}_t =  2*D_t*(\mbox{PRICE}_{t} - \frac{(\mbox{BID}_{t}+\mbox{OFR}_{t})}{2}),
    }
    where \eqn{D_t} is 1 (-1) if \eqn{trade_t} was buy (sell) (see Boehmer (2005), Bessembinder (2003)). 
    Note that the input of this function consists of the matched trades and quotes,
    so this is were the time indication refers to (and thus not to the registered quote timestamp).
  } 
  \item{realizedSpread: realized spread}{ 
   \deqn{
     \mbox{realized spread}_t =  2*D_t*(\mbox{PRICE}_{t} - \frac{(\mbox{BID}_{t+300}+\mbox{OFR}_{t+300})}{2}),
   }
   
   where \eqn{D_t} is 1 (-1) if \eqn{trade_t} was buy (sell) (see Boehmer (2005), Bessembinder (2003)). 
   Note that the time indication of \eqn{\mbox{BID}} and \eqn{\mbox{OFR}} refers 
   to the registered time of the quote in seconds.
 }
 
 \item{valueTrade: trade value}{ 
   \deqn{
     \mbox{trade value}_t =  \mbox{SIZE}_{t}*\mbox{PRICE}_{t}.
   }
 } 
 
 \item{signedValueTrad: signed trade value}{
   \deqn{
     \mbox{signed trade value}_t =  D_t * (\mbox{SIZE}_{t}*\mbox{PRICE}_{t}),}
   where \eqn{D_t} is 1 (-1) if \eqn{trade_t} was buy (sell) 
   (see Boehmer (2005), Bessembinder (2003)).
 }  
 
 \item{depthImbalanceDifference: depth imbalance (as a difference)}{
   \deqn{
     \mbox{depth imbalance (as difference)}_t =  \frac{D_t *(\mbox{OFRSIZ}_{t}-\mbox{BIDSIZ}_{t})}{(\mbox{OFRSIZ}_{t}+\mbox{BIDSIZ}_{t})},
   }
   where \eqn{D_t} is 1 (-1) if \eqn{trade_t} was buy (sell) (see Boehmer (2005), Bessembinder (2003)). 
   Note that the input of this function consists of the matched trades and quotes,
   so this is were the time indication refers to (and thus not to the registered quote timestamp).
 } 
 
 \item{depthImbalanceRatio: depth imbalace (as ratio)}{
   \deqn{
     \mbox{depth imbalance (as ratio)}_t =  (\frac{\mbox{OFRSIZ}_{t}}{\mbox{BIDSIZ}_{t}})^{D_t},
   }
   where \eqn{D_t} is 1 (-1) if \eqn{trade_t} was buy (sell) (see Boehmer (2005), Bessembinder (2003)). 
   Note that the input of this function consists of the matched trades and quotes,
   so this is were the time indication refers to (and thus not to the registered quote timestamp).
 } 
 
 \item{proportionalEffectiveSpread: proportional effective spread}{
   \deqn{
     \mbox{proportional effective spread}_t =  \frac{\mbox{effective spread}_t}{(\mbox{OFR}_{t}+\mbox{BID}_{t})/2}
   }
   (Venkataraman, 2001).
   
   Note that the input of this function consists of the matched trades and quotes,
   so this is were the time indication refers to (and thus not to the registered quote timestamp).
 } 
 
 \item{proportionalRealizedSpread: proportional realized spread}{
   \deqn{
     \mbox{proportional realized spread}_t =  \frac{\mbox{realized spread}_t}{(\mbox{OFR}_{t}+\mbox{BID}_{t})/2}
   }
   (Venkataraman, 2001).
   
   Note that the input of this function consists of the matched trades and quotes,
   so this is were the time indication refers to (and thus not to the registered 
 } 
 
 \item{priceImpact: price impact}{
   \deqn{
     \mbox{price impact}_t =  \frac{\mbox{effective spread}_t - \mbox{realized spread}_t}{2}
   }
   (see Boehmer (2005), Bessembinder (2003)). 
 }
 
 \item{proportionalPriceImpact: proportional price impact}{
   \deqn{
     \mbox{proportional price impact}_t =  \frac{\frac{(\mbox{effective spread}_t - \mbox{realized spread}_t)}{2}}{\frac{\mbox{OFR}_{t}+\mbox{BID}_{t}}{2}}
   }
   (Venkataraman, 2001).
   Note that the input of this function consists of the matched trades and
   quotes, so this is where the time indication refers to (and thus not to the
                                                           registered quote timestamp).
 }  
 
 \item{halfTradedSpread: half traded spread}{
   \deqn{
     \mbox{half traded spread}_t =  D_t*(\mbox{PRICE}_{t} - \frac{(\mbox{BID}_{t}+\mbox{OFR}_{t})}{2}),
   }
   where \eqn{D_t} is 1 (-1) if \eqn{trade_t} was buy (sell) (see Boehmer (2005), Bessembinder (2003)). 
   Note that the input of this function consists of the matched trades and quotes,
   so this is were the time indication refers to (and thus not to the registered quote timestamp).
 } 
 
 \item{proportionalHalfTradedSpread: proportional half traded spread}{ 
   \deqn{
     \mbox{proportional half traded spread}_t =  \frac{\mbox{half traded spread}_t}{\frac{\mbox{OFR}_{t}+\mbox{BID}_{t}}{2}}.
   }
   Note that the input of this function consists of the matched trades and quotes,
   so this is were the time indication refers to (and thus not to the registered quote timestamp).
 }
 
 \item{squaredLogReturn: squared log return on trade prices}{
   \deqn{
     \mbox{squared log return on Trade prices}_t =  (\log(\mbox{PRICE}_{t})-\log(\mbox{PRICE}_{t-1}))^2.
   }
 } 
 
 \item{absLogReturn: absolute log return on trade prices}{
   \deqn{
     \mbox{absolute log return on Trade prices}_t =  |\log(\mbox{PRICE}_{t})-\log(\mbox{PRICE}_{t-1})|.
   }
 } 
 
 \item{quotedSpread: quoted spread}{
   \deqn{
     \mbox{quoted spread}_t =  \mbox{OFR}_{t}-\mbox{BID}_{t}
   }
   Note that the input of this function consists of the matched trades and
   quotes, so this is where the time indication refers to (and thus not to the
                                                           registered quote timestamp).
 } 
 
 \item{proportionalQuotedSpread: proportional quoted spread}{
   \deqn{
     \mbox{proportional quoted spread}_t =  \frac{\mbox{quoted spread}_t}{\frac{\mbox{OFR}_{t}+\mbox{BID}_{t}}{2}}
   }
   (Venkataraman, 2001).
   Note that the input of this function consists of the matched trades and
   quotes, so this is where the time indication refers to (and thus not to the
                                                           registered quote timestamp).
 }  
 
 \item{logQuotedSpread: log quoted spread}{
   \deqn{
     \mbox{log quoted spread}_t =  \log(\frac{\mbox{OFR}_{t}}{\mbox{BID}_{t}})
   }
   
   (Hasbrouck and Seppi, 2001).
   Note that the input of this function consists of the matched trades and
   quotes, so this is where the time indication refers to (and thus not to the
                                                           registered quote timestamp).
   
 }
 
 \item{logQuotedSize: log quoted size}{
   \deqn{
     \mbox{log quoted size}_t =  \log(\mbox{OFRSIZ}_{t})-\log(\mbox{BIDSIZ}_{t})
   }
   
   (Hasbrouck and Seppi, 2001).
   Note that the input of this function consists of the matched trades and
   quotes, so this is where the time indication refers to (and thus not to the
                                                           registered quote timestamp).
 } 
 
 \item{quotedSlope: quoted slope}{
   \deqn{
     \mbox{quoted slope}_t =  \frac{\mbox{quoted spread}_t}{\mbox{log quoted size}_t}
   }
   (Hasbrouck and Seppi, 2001).
 }
 
 \item{logQSlope: log quoted slope}{
   \deqn{
     \mbox{log quoted slope}_t =  \frac{\mbox{log quoted spread}_t}{\mbox{log quoted size}_t}.
   }
 } 
 
 \item{midQuoteSquaredReturn: midquote squared return}{
   \deqn{
     \mbox{midquote squared return}_t =  (\log(\mbox{midquote}_{t})-\log(\mbox{midquote}_{t-1}))^2,
   }
   
   where \eqn{\mbox{midquote}_{t} = \frac{\mbox{BID}_{t} + \mbox{OFR}_{t}}{2}}.
 }
 
 \item{midQuoteAbsReturn: midquote absolute return}{
   \deqn{
     \mbox{midquote absolute return}_t =  |\log(\mbox{midquote}_{t})-\log(\mbox{midquote}_{t-1})|,
   }
   
   where \eqn{\mbox{midquote}_{t} = \frac{\mbox{BID}_{t} + \mbox{OFR}_{t}}{2}}.
 }
 
 \item{signedTradeSize: signed trade size}{
   \deqn{
     \mbox{signed trade size}_t =  D_t * \mbox{SIZE}_{t},}
   
   where \eqn{D_t} is 1 (-1) if \eqn{trade_t} was buy (sell).
 }
 }
}
\examples{
tqdata <- matchTradesQuotes(sample_tdata, sample_qdata)
res <- getLiquidityMeasures(tqdata)
head(res)
}
\references{
Bessembinder, H. (2003). Issues in assessing trade execution costs. Journal of Financial Markets, 223-257.
Boehmer, E. (2005). Dimensions of execution quality: Recent evidence for US equity markets. Journal of Financial Economics 78 (3), 553-582.
Hasbrouck, J. and D. J. Seppi (2001). Common factors in prices, order flows and liquidity. Journal of Financial Economics, 383-411.
Venkataraman, K. (2001). Automated versus floor trading: An analysis of execution costs on the paris and new york exchanges. The Journal of Finance, 56, 1445-1485.
}
