% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readQN.R
\name{qn2.read.fstat}
\alias{qn2.read.fstat}
\title{Read QuantiNemo extended format for genotype files
 
Read QuantiNemo (\url{http://www2.unil.ch/popgen/softwares/quantinemo/}) genotype files extended format (option 2)}
\usage{
qn2.read.fstat(fname, na.s = c("NA","NaN"))
}
\arguments{
\item{fname}{quantinemo file name}

\item{na.s}{na string used}
}
\value{
dat  a data frame with nloc+1 columns, the first being the population
 to which the individual belongs and the next being the genotypes, one column per locus; 
 and ninds rows

sex  the sex of the individuals
}
\description{
Read QuantiNemo extended format for genotype files
 
Read QuantiNemo (\url{http://www2.unil.ch/popgen/softwares/quantinemo/}) genotype files extended format (option 2)
}
\examples{
  dat<-qn2.read.fstat(system.file("extdata","qn2_sex.dat",package="hierfstat"))
  sexbias.test(dat[[1]],sex=dat[[2]])
}
\references{
\href{https://pubmed.ncbi.nlm.nih.gov/30816926/}{Neuenschwander S, Michaud F, Goudet J (2019)} 
QuantiNemo 2: a Swiss knife to simulate complex demographic and genetic scenarios, 
forward and backward in time. Bioinformatics 35:886

\href{https://academic.oup.com/bioinformatics/article/24/13/1552/237901}{Neuenschwander S, Hospital F, Guillaume F, Goudet J (2008)} 
quantiNEMO: an individual-based program to simulate quantitative traits with explicit 
genetic architecture in a dynamic metapopulation. Bioinformatics 24:1552
}
\seealso{
\code{\link{read.fstat}}
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}
}
