% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_bindings.R
\name{causal_bindings}
\alias{causal_bindings}
\title{Compute input and output bindings}
\usage{
causal_bindings(eventlog, dependencies, type = c("nearest"))
}
\arguments{
\item{eventlog}{The bupaR event log.}

\item{dependencies}{A dependency matrix obtained, for example, through \code{\link{dependency_matrix}}.}

\item{type}{The heuristic used to determine the bindings. Currently only \code{nearest} is available.}
}
\value{
A data frame
}
\description{
Computes the input- and output bindings for use in a causal map. Several heuristics may be used to determine
the activities that are activated or consumed by an event. The Flexible Heuristic Miner (FHM) paper describes
a heuristic that looks ahead (or looks back) until the end of the trace and determines those activities as activated
for which no other cause (activity in a causal dependency) is found. This approach is implemented as type \code{nearest}.
}
\examples{
causal_bindings(L_heur_1,
                dependencies = dependency_matrix(L_heur_1))

}
