% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{distributeGuessAsExpectedValue}
\alias{distributeGuessAsExpectedValue}
\title{Distributes guesses of 3x3 confusion matrix to expected value of 1 and -1.}
\usage{
distributeGuessAsExpectedValue(confusion_matrix_3x3)
}
\arguments{
\item{confusion_matrix_3x3}{A 3x3 matrix where the middle column is counts of
guesses.}
}
\value{
A 3x3 confusion matrix with 0's in the middle column.
}
\description{
Given a 3x3 confusion matrix, distributes guesses in column 2 using the
expected value.  That is, moves half of guess counts (in column 2) to -1
(column 1) and the other half to 1 (column 3).
}
\details{
-1 0 1
-1  2 2 2
0   4 4 4
1   6 6 6
becomes
   -1 0 1
-1  3 0 3
0   6 0 6
1   9 0 9
}
