% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psm.R
\name{create_PsmCurves}
\alias{create_PsmCurves}
\alias{create_PsmCurves.flexsurvreg_list}
\alias{create_PsmCurves.params_surv_list}
\title{Create \code{PsmCurves} object}
\usage{
create_PsmCurves(object, ...)

\method{create_PsmCurves}{flexsurvreg_list}(
  object,
  input_data,
  n = 1000,
  uncertainty = c("normal", "bootstrap", "none"),
  est_data = NULL,
  ...
)

\method{create_PsmCurves}{params_surv_list}(object, input_data, ...)
}
\arguments{
\item{object}{An object of the appropriate class containing either fitted
survival models or parameters of survival models.}

\item{...}{Further arguments passed to or from other methods. Passed to \code{\link[=create_params.partsurvfit]{create_params.partsurvfit()}}
when \code{object} is of class \code{\link{flexsurvreg_list}}.}

\item{input_data}{An object of class \code{expanded_hesim_data} returned by
\code{\link[=expand.hesim_data]{expand.hesim_data()}}. Must be expanded by the data tables \code{"strategies"} and
\code{"patients"}.}

\item{n}{Number of random observations to draw. Not used if \code{uncertainty = "none"}.}

\item{uncertainty}{Method determining how parameter uncertainty should be handled.
If \code{"normal"}, then parameters are randomly drawn from their multivariate normal
distribution. If \code{"bootstrap"}, then parameters are bootstrapped using \code{\link{bootstrap}}.
If \code{"none"}, then only point estimates are returned.}

\item{est_data}{A \code{data.table} or \code{data.frame} of estimation data
used to fit survival models during bootstrap replications.}
}
\value{
Returns an \code{R6Class} object of class \code{\link{PsmCurves}}.
}
\description{
A generic function for creating a \code{\link{PsmCurves}} object.
}
\details{
Disease models may either be created from a fitted statistical
model or from a parameter object. In the case of the former, \code{input_data}
is a data frame like object that is used to look for variables from
the statistical model that are required for simulation. In this sense,
\code{input_data} is very similar to the \code{newdata} argument in most \code{\link[=predict]{predict()}}
methods (e.g., see \code{\link[=predict.lm]{predict.lm()}}). In other words, variables used in the
\code{\link{formula}} of the statistical model must also be in \code{input_data}.

In the case of the latter, the columns of \code{input_data} must be named in a
manner that is consistent with the parameter object. In the typical case
(e.g., with \code{\link{params_surv}} or \code{\link{params_mlogit}}), the parameter object
contains coefficients from a regression model, usually stored as matrix
where rows index parameter samples (i.e., for a probabilistic sensitivity
analysis) and columns index model terms. In such instances, there must
be one column from \code{input_data} with the same name as each model term in the
coefficient matrix; that is, the columns in \code{input_data} are matched with
the columns of the coefficient matrices by name. If there are model terms
in the coefficient matrices that are not contained in \code{input_data}, then
an error will be thrown.
}
\seealso{
See \code{\link{PsmCurves}} and \code{\link{Psm}} for examples. \code{\link{PsmCurves}} provides
an example in which a model is parameterized both with
(via \code{create_PsmCurves.flexsurvreg_list()}) and without (via
\code{create_PsmCurves.params_surv_list()}) access to patient-level data.
The \code{\link{Psm}} example shows how state probabilities, costs, and utilities can
be computed from predicted survival curves.
}
