% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_def.R
\name{tpmatrix}
\alias{tpmatrix}
\title{Transition probability matrix}
\usage{
tpmatrix(...)
}
\arguments{
\item{...}{Named values of expressions defining elements of the matrix. The parameter
values of the matrix elements should refer to parameters defined using
\code{\link[=define_rng]{define_rng()}} or \code{\link[=define_tparams]{define_tparams()}}.}
}
\value{
Returns a \code{tpmatrix} object that inherits from \code{data.table}
where each column is an element of the transition probability matrix with
elements ordered rowwise.
}
\description{
\code{tpmatrix()} both defines and evaluates a transition probability matrix in which
elements are expressions. This function is used within \code{define_tparams()} to
create a transition probability matrix used for simulation modeling.
}
\details{
The matrix is filled rowwise, meaning that each row should sum to 1. It is evaluated
in the environment used by \code{\link[=eval_tparams]{eval_tparams()}} so that any objects available
within \code{\link[=define_tparams]{define_tparams()}} can be used by \code{tpmatrix()}. The complementary probability
equal to 1 minus the sum of the probabilities of all other rows can be
conveniently referred to as \code{C}.
}
\examples{
p <- c(.7, .6)
tpmatrix(
  C, p,
  0, 1
)
}
\seealso{
\code{\link[=define_model]{define_model()}}, \code{\link[=define_tparams]{define_tparams()}}
}
