% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intermodal_route.R
\name{intermodal_route}
\alias{intermodal_route}
\title{HERE Intermodal Routing API: Calculate Route}
\usage{
intermodal_route(
  origin,
  destination,
  datetime = Sys.time(),
  results = 3,
  transfers = -1,
  url_only = FALSE
)
}
\arguments{
\item{origin}{\code{sf} object, the origin locations of geometry type \code{POINT}.}

\item{destination}{\code{sf} object, the destination locations of geometry type \code{POINT}.}

\item{datetime}{\code{POSIXct} object, datetime for the departure (\code{default = Sys.time()}).}

\item{results}{numeric, maximum number of suggested route alternatives (Valid range: 1 and 7, \code{default = 3}).}

\item{transfers}{numeric, maximum number of transfers allowed per route (Valid range: -1 and 6, \code{default = -1}).}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the requested intermodal routes.
}
\description{
Calculates route geometries (\code{LINESTRING}) between given pairs of points using the HERE 'Intermodal Routing' API.
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

# Change POIs to Berlin, as service is not available in Switzerland
library(sf)
poi <- data.frame(
 name = c("HERE Berlin", "Treptow", "Potsdam", "Tiergarten"),
 lng = c(13.384944, 13.461215, 13.058351, 13.336490),
 lat = c(52.531056, 52.493908, 52.403587, 52.514557)
) \%>\%
 st_as_sf(coords = c("lng", "lat")) \%>\%
 st_set_crs(4326)

# Intermodal routing
routes <- intermodal_route(
  origin = poi[1:2, ],
  destination = poi[3:4, ],
  url_only = TRUE
)
}
\references{
\href{https://developer.here.com/documentation/intermodal-routing/dev_guide/index.html}{HERE Intermodal Routing API: Routes}
}
