% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_func.R
\name{draw_wheel}
\alias{draw_wheel}
\title{Create helical wheels to visualize alpha helical sequences.}
\usage{
draw_wheel(name, seq)
}
\arguments{
\item{name}{character vector containing sequence names; sequence
names can be empty, but \code{length(name)} must equal \code{length(seq)}.}

\item{seq}{character vector containing residue sequences in order
from N-terminus to C-terminus. Each sequence must contain at least
two residues, and \code{length(name)} must equal \code{length(seq)}.}
}
\description{
This function produces PNG files, one for each sequence in
\code{seq}, each of which contains a helical wheel visualizing
the sequence. Each sequence in the \code{seq} vector is of class
character, lists amino acid sequences from N-terminus to
C-terminus, and must contain a maximum of 18 characters. The
PNG files are stored in the current working directory (as
obtained by the \code{getwd()} command). The PNG files created are
all of the same size (600 x 600 pixels), with the residue in the upper
half of the wheel lying at the horizontal center representing the
amino acid at the N-terminus.
}
\examples{
draw_wheel("TestWheel", "AREKHLVLLKREGDIWKL")
}
