% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-splits-plot.R
\name{ts_splits_plot}
\alias{ts_splits_plot}
\title{Time Series Splits Plot}
\usage{
ts_splits_plot(.splits_obj, .date_col, .value_col)
}
\arguments{
\item{.splits_obj}{The predefined splits object.}

\item{.date_col}{The date column for the time series.}

\item{.value_col}{The value column of the time series.}
}
\value{
A time series cv plan plot
}
\description{
Sometimes we want to see the training and testing data in a plot. This is a
simple wrapper around a couple of functions from the \code{timetk} package.
}
\details{
You should already have a splits object defined. This function takes in three
parameters, the splits object, a date column and the value column.
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))

data <- ts_to_tbl(AirPassengers) \%>\%
  select(-index)

splits <- time_series_split(
    data
    , date_col
    , assess = 12
    , skip = 3
    , cumulative = TRUE
)

ts_splits_plot(
    .splits_obj = splits,
    .date_col   = date_col,
    .value_col  = value
)

}
\seealso{
\itemize{
\item \url{https://business-science.github.io/timetk/reference/index.html#section-cross-validation-plan-visualization-resample-sets-} (timetk)
\item \url{https://business-science.github.io/timetk/reference/plot_time_series_cv_plan.html}(tk_time_sers_cv_plan)
\item \url{https://business-science.github.io/timetk/reference/plot_time_series_cv_plan.html}(plot_time_series_cv_plan)
}
}
\author{
Steven P. Sanderson II, MPH
}
