% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_functions.R
\name{ts_compare_data}
\alias{ts_compare_data}
\title{Compare data over time periods}
\usage{
ts_compare_data(.data, .date_col, .start_date, .end_date, .periods_back)
}
\arguments{
\item{.data}{The date.frame/tibble that holds the data}

\item{.date_col}{The column with the date value}

\item{.start_date}{The start of the period you want to analyze}

\item{.end_date}{The end of the period you want to analyze}

\item{.periods_back}{How long ago do you want to compare data too. Time units
are collapsed using \code{lubridate::floor_date()}. The value can be:
\itemize{
\item second
\item minute
\item hour
\item day
\item week
\item month
\item bimonth
\item quarter
\item season
\item halfyear
\item year
}

Arbitrary unique English abbreviations as in the \code{lubridate::period()} constructor are allowed.}
}
\value{
A tibble.
}
\description{
Given a tibble/data.frame, you can get date from two different but comparative
date ranges. Lets say you want to compare visits in one year to visits from 2
years before without also seeing the previous 1 year. You can do that with
this function.
}
\details{
\itemize{
\item Uses the \code{timetk::filter_by_time()} function in order to filter the date
column.
\item Uses the \code{timetk::subtract_time()} function to subtract time from the start date.
}
}
\examples{
suppressPackageStartupMessages(library(healthyR.data))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(timetk))
ts_compare_data(
  .data           = healthyR_data
  , .date_col     = visit_start_date_time
  , .start_date   = "2019-01-01"
  , .end_date     = "2019-12-31"
  , .periods_back = "2 years"
  ) \%>\%
  select(visit_start_date_time) \%>\%
  summarise_by_time(
    .date_var = visit_start_date_time
    , .by     = "year"
    , visits  = n()
  )

ts_compare_data(
 .data = healthyR_data
 , .date_col     = visit_end_date_time
 , .start_date   = "2019-01-01"
 , .end_date     = "2019-12-31"
 , .periods_back = "2 years"
)

}
\author{
Steven P. Sanderson II, MPH
}
