% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_iso.R
\name{build_iso_query}
\alias{build_iso_query}
\title{build_iso_query}
\usage{
build_iso_query(
  point,
  source,
  value,
  type,
  profile,
  direction,
  constraints,
  distance_unit,
  time_unit
)
}
\arguments{
\item{point}{\code{character}; point formated with \code{x_to_iso}.}

\item{source}{\code{character}; This parameter specifies which source will
be used for the calculation. Currently, "valhalla" and "pgr" sources are
available (default "pgr"). See section \code{SOURCE} for further information.}

\item{value}{\code{numeric}; A quantity of time or distance.}

\item{type}{\code{character}; Specifies the type of calculation performed:
"time" for isochrone or "distance" for isodistance (isochrone by default).}

\item{profile}{\code{character}; Type of cost used for calculation: "pedestrian"
for #' pedestrians and "car" for cars. and "car" for cars ("pedestrian"
by default).}

\item{direction}{\code{character}; Direction of travel. Either define a
"departure" point and obtain the potential arrival points. Or define an
"arrival" point and obtain the potential points ("departure" by default).}

\item{constraints}{Used to express constraints on the characteristics
to calculate isochrones/isodistances. See section \code{CONSTRAINTS}.}

\item{distance_unit}{\code{character}; Allows you to specify the unit in which
distances are expressed in the answer: "meter" or "kilometer" (meter by
default).}

\item{time_unit}{\code{character}; Allows you to specify the unit in which times
are expressed in the answer: "hour", "minute" or "second" (minutes by
default).}
}
\value{
\code{httr2_request} object
}
\description{
build query for isochrone-dist API
}
