% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.Classes.R
\docType{class}
\name{SNP_time_series-class}
\alias{SNP_time_series}
\alias{SNP_time_series-class}
\title{An S4 class storing time series data}
\description{
An S4 class representing the input data for haplotype-block 
reconstruction
}
\details{
Time-series data is initialzed to be used for haplotype-block reconstruction.

An S4 class storing the initialized input data for haplotype-block 
reconstruction with \code{reconstruct_hb}. Genome-wide time series data for 
multiple time points and replicates is stored along with replicate and time 
point information of the time series data. The stored data is filtered for
SNPs with a maximum minor frequency in the experimental starting population 
and a minimum frequency change \code{minfreqchange} that is required for 
\code{minrepl} many replicates. An object of the class 
\code{SNP_time_series} can only be created with the function 
\code{\link{initialize_SNP_time_series}}.
}
\section{Slots}{

\describe{
\item{\code{col.info}}{data.table with columns 'chr', 'pos', 'base.freq' and window. 
Each row corresponds to a SNP position that fullfills the filtering criteria.}

\item{\code{lib.freqs}}{data.table with columns for the different libraries (time 
points and replicates) and rows for all SNP positions that fullfill the 
filtering criteria.}

\item{\code{pos.cM}}{numeric vector corresponding to SNP positions in col.info with
genetic positions in cM.}

\item{\code{pop.ident}}{numeric vector specifying the identity of each library in 
terms of replicate ID}

\item{\code{pop.generation}}{numeric vector specifying the time point of the 
respective library}

\item{\code{use.libs}}{logical vector specifying which libraries should be used for 
haplotype-block reconstruction}

\item{\code{winsize}}{numeric specifying the window size on which to perform 
the analysis}

\item{\code{win.scale}}{character string specifying which genome-wide distance 
measure is used for window definition. Options are "bp" (base pairs) or 
"cM" (centi Morgan). cM distances can only be used if gentic positions are 
provided in 'pos.cM' (default="Mb").}

\item{\code{min.minor.freq}}{numeric specifying the minimum frequency of the 
minor allele (polarized in the experimental starting population) to be 
included in the analysis (default=0).}

\item{\code{max.minor.freq}}{numeric specifying the maximum frequency of the 
minor allele (polarized in the experimental starting population) to be 
included in the analysis (default=3/113).}

\item{\code{min.lib.frac}}{minimum fraction of non-NA values for a SNP across 
libraries (only using libraries specified in \code{use.libs}) (default=0.75).}

\item{\code{minfreqchange}}{numeric specifying the minimum frequency change 
required in 'minrepl' replicates 
required to
include the SNP in the analysis}

\item{\code{minrepl}}{numeric specifying the number of replicates, in which 
the 'minfreqchange' is required 
to include the SNP in the analysis}
}}
\author{
Susanne U. Franssen
}
\references{
Franssen, Barton & Schloetterer 2016, \href{http://mbe.oxfordjournals.org/content/early/2016/10/03/molbev.msw210.abstract}{Reconstruction of haplotype-blocks
selected during experimental evolution}, \href{http://mbe.oxfordjournals.org/}{MBE}
}
\seealso{
\code{\link{ex_dat}} \code{\link{initialize_SNP_time_series}} \code{\link{reconstruct_hb}}
}

