% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JunctionDetection.R
\name{processDocument}
\alias{processDocument}
\title{Process Document}
\usage{
processDocument(path)
}
\arguments{
\item{path}{File path for handwriting document. The document must be in PNG file format.}
}
\value{
The processed document as a list
}
\description{
Load a handwriting sample from a PNG image. Then binarize, thin, and split the handwriting into graphs.
}
\examples{
image_path <- system.file("extdata", "phrase_example.png", package = "handwriter")
doc <- processDocument(image_path)
plotImage(doc)
plotImageThinned(doc)
plotNodes(doc)

}
