% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_age_models.R
\name{calc_stat_scores}
\alias{calc_stat_scores}
\alias{calc_ks_score}
\alias{calc_chi_score}
\title{Compute test statistics for comparing actual and estimated ages}
\usage{
calc_ks_score(
  data,
  summary_fun = mean,
  age_col = "age",
  suppress_warnings = TRUE,
  return_val = "statistic",
  ...
)

calc_chi_score(
  data,
  age_col = "age",
  suppress_warnings = TRUE,
  return_val = "statistic",
  ...
)
}
\arguments{
\item{data}{A data.frame containing estimated ages as returned by
\code{\link{assign_ages}}}

\item{summary_fun}{Function used to compute summary statistics for
\code{calc_ks_score} for each age group (default is \code{mean})}

\item{age_col}{Character string specifying the name of the age column}

\item{suppress_warnings}{Logical. Should any warnings from the function
call to \code{ks.test} or \code{chisq.test} be suppressed (TRUE, the default)}

\item{return_val}{Character. The name of the object to return from the given
test}

\item{...}{Additional arguments to pass to \code{summary_fun}
(\code{calc_ks_score}) or \code{chisq.test} (\code{calc_chi_score})}
}
\value{
A numeric value for each level that was used in the model to assign
ages
}
\description{
Using these functions you can compute either a Kolmogorov-Smirnov (KS)
statistic or a Chi-squared test statistic to compare estimated ages to actual
ages. See details for how each test works and what is reported.
}
\details{
The KS test compares length distributions for each age class from known ages
against that of estimated ages computed by the \code{\link{assign_ages}}
function. The output is a summary value of the test statistics as specified
by \code{summary_fun}.

The \code{calc_chi_score} function performs a Chi-square test (using the
\code{\link[stats]{chisq.test}} function) on the number of estimated and
actual ages for each age group.
}
\examples{
halk <- make_halk(spp_data, levels = c("spp"))
newdat <- laa_data
newdat$spp <- "bluegill"
pred_ages <- assign_ages(newdat, halk)
calc_ks_score(pred_ages)
calc_chi_score(pred_ages)
}
