% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_utilities.R
\name{num_cells}
\alias{num_cells}
\title{Get total H3 cells}
\usage{
num_cells(res = NULL, fast = TRUE)
}
\arguments{
\item{res}{Integer; Desired H3 resolution. See
\url{https://h3geo.org/docs/core-library/restable/} for allowable values and related dimensions.}

\item{fast}{Logical; whether to retrieve values from a locally stored table or
recalculate from source.}
}
\value{
Numeric; H3 cell count.
}
\description{
This function returns total number of H3 cells at a given resolution.
}
\note{
Above resolution 8 the exact count cannot be represented in a
  JavaScript 32-bit number, so consumers should use caution when applying
  further operations to the output.
}
\examples{
# Return cell count for resolution 8
num_cells(res = 8)

}
