% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.naiveBayes}
\alias{h2o.naiveBayes}
\title{Naive Bayes Model in H2O}
\usage{
h2o.naiveBayes(x, y, training_frame, model_id, laplace = 0,
  threshold = 0.001, eps = 0, compute_metrics = TRUE)
}
\arguments{
\item{x}{A vector containing the names or indices of the predictor variables to use in building the model.}

\item{y}{The name or index of the response variable. If the data does not contain a header, this is the
column index number starting at 0, and increasing from left to right. The response must be a categorical
variable with at least two levels.}

\item{training_frame}{An H2O Frame object containing the variables in the model.}

\item{model_id}{(Optional) The unique id assigned to the resulting model. If
none is given, an id will automatically be generated.}

\item{laplace}{A positive number controlling Laplace smoothing. The default zero disables smoothing.}

\item{threshold}{The minimum standard deviation to use for observations without enough data. Must be
at least 1e-10.}

\item{eps}{A threshold cutoff to deal with numeric instability, must be positive.}

\item{compute_metrics}{A logical value indicating whether model metrics should be computed. Set to
FALSE to reduce the runtime of the algorithm.}
}
\value{
Returns an object of class \linkS4class{H2OBinomialModel} if the response has two categorical levels,
        and \linkS4class{H2OMultinomialModel} otherwise.
}
\description{
Compute naive Bayes probabilities on an H2O dataset.
}
\details{
The naive Bayes classifier assumes independence between predictor variables conditional
on the response, and a Gaussian distribution of numeric predictors with mean and standard
deviation computed from the training dataset. When building a naive Bayes classifier,
every row in the training dataset that contains at least one NA will be skipped completely.
If the test dataset has missing values, then those predictors are omitted in the probability
calculation during prediction.

The naive Bayes classifier assumes independence between predictor variables conditional
       on the response, and a Gaussian distribution of numeric predictors with mean and standard
       deviation computed from the training dataset. When building a naive Bayes classifier,
       every row in the training dataset that contains at least one NA will be skipped completely.
       If the test dataset has missing values, then those predictors are omitted in the probability
       calculation during prediction.
}
\examples{
\donttest{
 h2o.init()
 votesPath <- system.file("extdata", "housevotes.csv", package="h2o")
 votes.hex <- h2o.uploadFile(path = votesPath, header = TRUE)
 h2o.naiveBayes(x = 2:17, y = 1, training_frame = votes.hex, laplace = 3)
}
}

