% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.which_max}
\alias{h2o.which_max}
\alias{which.max.H2OFrame}
\alias{which.min.H2OFrame}
\title{Which indice contains the max value?}
\usage{
h2o.which_max(x, na.rm = TRUE, axis = 0)

which.max.H2OFrame(x, na.rm = TRUE, axis = 0)

which.min.H2OFrame(x, na.rm = TRUE, axis = 0)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{na.rm}{\code{logical}. Indicate whether missing values should be removed.}

\item{axis}{\code{integer}. Indicate whether to calculate the mean down a column (0) or across a row (1).}
}
\value{
Returns an H2OFrame object.
}
\description{
Get the index of the max value in a column or row
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/chicago/chicagoCensus.csv"
census <- h2o.importFile(f)
census[, 1] <- as.factor(census[, 1])
dl_model <- h2o.deeplearning(x = c(1:3), y = 4, hidden = c(17, 191), 
                            epochs = 1, training_frame = census, 
                            balance_classes = FALSE,
                            export_weights_and_biases = TRUE)
h2o.which_max(census["PER CAPITA INCOME "], na.rm = FALSE, axis = 0)
}
}
\seealso{
\code{\link[base]{which.min}} for the base R method, \code{which.max()}.
}
