% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{h2o.varimp,H2OFrame-method}
\alias{h2o.varimp,H2OFrame-method}
\title{Retrieve the variable importance.}
\usage{
\S4method{h2o.varimp}{H2OFrame}(object, num_of_features = NULL)
}
\arguments{
\item{object}{A leaderboard frame.}

\item{num_of_features}{Integer specifying the number of features returned based on the maximum
importance across the models. Use NULL for unlimited. Defaults to NULL.}
}
\description{
Retrieve the variable importance.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/prostate/prostate_complete.csv.zip"
pros <- h2o.importFile(f)
response <- "GLEASON"
predictors <- c("ID", "AGE", "CAPSULE", "DCAPS", "PSA", "VOL", "DPROS")
aml <- h2o.automl(x = predictors, y = response, training_frame = pros, max_runtime_secs = 60)
h2o.varimp(aml@leaderboard[1:5,])
}
}
