% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.transform,H2OTargetEncoderModel-method}
\alias{h2o.transform,H2OTargetEncoderModel-method}
\title{Applies target encoding to a given dataset}
\usage{
\S4method{h2o.transform}{H2OTargetEncoderModel}(
  model,
  data,
  blending = NULL,
  inflection_point = -1,
  smoothing = -1,
  noise = NULL,
  as_training = FALSE,
  ...
)
}
\arguments{
\item{model}{A trained model representing the transformation strategy}

\item{data}{An H2OFrame with data to be transformed}

\item{blending}{Use blending during the transformation. Respects model settings when not set.}

\item{inflection_point}{Blending parameter. Only effective when blending is enabled.
By default, model settings are respected, if not overridden by this setting.}

\item{smoothing}{Blending parameter. Only effective when blending is enabled.
By default, model settings are respected, if not overridden by this setting.}

\item{noise}{An amount of random noise added to the encoding, this helps prevent overfitting.
By default, model settings are respected, if not overridden by this setting.}

\item{as_training}{Must be set to True when encoding the training frame. Defaults to False.}

\item{...}{Mainly used for backwards compatibility, to allow deprecated parameters.}
}
\value{
Returns an H2OFrame object with data transformed.
}
\description{
Applies target encoding to a given dataset
}
