% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.feature_interaction}
\alias{h2o.feature_interaction}
\title{Feature interactions and importance, leaf statistics and split value histograms in a tabular form.
Available for XGBoost and GBM.}
\usage{
h2o.feature_interaction(
  model,
  max_interaction_depth = 100,
  max_tree_depth = 100,
  max_deepening = -1
)
}
\arguments{
\item{model}{A trained xgboost model.}

\item{max_interaction_depth}{Upper bound for extracted feature interactions depth. Defaults to 100.}

\item{max_tree_depth}{Upper bound for tree depth. Defaults to 100.}

\item{max_deepening}{Upper bound for interaction start deepening (zero deepening => interactions 
starting at root only). Defaults to -1.}
}
\description{
Metrics:
Gain - Total gain of each feature or feature interaction.
FScore - Amount of possible splits taken on a feature or feature interaction.
wFScore - Amount of possible splits taken on a feature or feature interaction weighed by 
the probability of the splits to take place.
Average wFScore - wFScore divided by FScore.
Average Gain - Gain divided by FScore.
Expected Gain - Total gain of each feature or feature interaction weighed by the probability to gather the gain.
Average Tree Index
Average Tree Depth
}
\examples{
\dontrun{
library(h2o)
h2o.init()
boston <- h2o.importFile(
       "https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv",
        destination_frame="boston"
        )
boston_xgb <- h2o.xgboost(training_frame = boston, y = "medv", seed = 1234)
feature_interactions <- h2o.feature_interaction(boston_xgb)
}
}
