% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_variable_group_header.R
\name{add_variable_group_header}
\alias{add_variable_group_header}
\title{Variable Group Header}
\usage{
add_variable_group_header(x, header, variables, indent = 4L)
}
\arguments{
\item{x}{(\code{tbl_summary})\cr
gtsummary object of class \code{'tbl_summary'}}

\item{header}{(\code{string})\cr
string of the header to place above the variable group}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to group that appear in \code{x$table_body}.
Selected variables should be appear consecutively in table.}

\item{indent}{(\code{integer})\cr
An integer indicating how many space to indent text.
All rows in the group will be indented by this amount. Default is \code{4}.}
}
\value{
a gtsummary table
}
\description{
Some data are inherently grouped, and should be reported together.
Grouped variables are all indented together.
This function indents the variables that should be reported together while
adding a header above the group.
}
\details{
This function works by inserting a row into the \code{x$table_body} and
indenting the group of selected variables.
This function cannot be used in conjunction with all functions in gtsummary;
for example, \code{bold_labels()} will bold the incorrect rows after running
this function.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("cardx", "car", "broom", "broom.helpers", "parameters"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
set.seed(11234)
data.frame(
  exclusion_age = sample(c(TRUE, FALSE), 20, replace = TRUE),
  exclusion_mets = sample(c(TRUE, FALSE), 20, replace = TRUE),
  exclusion_physician = sample(c(TRUE, FALSE), 20, replace = TRUE)
) |>
  tbl_summary(
    label = list(exclusion_age = "Age",
                 exclusion_mets = "Metastatic Disease",
                 exclusion_physician = "Physician")
  ) |>
  add_variable_group_header(
    header = "Exclusion Reason",
    variables = starts_with("exclusion_")
  ) |>
  modify_caption("**Study Exclusion Criteria**")

# Example 2 ----------------------------------
lm(marker ~ trt + grade + age, data = trial) |>
  tbl_regression() |>
  add_global_p(keep = TRUE, include = grade) |>
  add_variable_group_header(
    header = "Treatment:",
    variables = trt
  ) |>
  add_variable_group_header(
    header = "Covariate:",
    variables = -trt
  ) |>
  # indent levels 8 spaces
  modify_column_indent(
    columns = "label",
    rows = row_type == "level",
    indent = 8L
  )
\dontshow{\}) # examplesIf}
}
