% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_p.R
\name{bold_p}
\alias{bold_p}
\title{Bold significant p-values}
\usage{
bold_p(x, t = 0.05, q = FALSE)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
Object created using gtsummary functions}

\item{t}{(scalar \code{numeric})\cr
Threshold below which values will be bold. Default is 0.05.}

\item{q}{(scalar \code{logical})\cr
When \code{TRUE} will bold the q-value column rather
than the p-value. Default is \code{FALSE}.}
}
\description{
Bold values below a chosen threshold (e.g. <0.05)
in a gtsummary tables.
}
\examples{
# Example 1 ----------------------------------
trial |>
  tbl_summary(by = trt, include = c(response, marker, trt), missing = "no") |>
  add_p() |>
  bold_p(t = 0.1)

# Example 2 ----------------------------------
glm(response ~ trt + grade, trial, family = binomial(link = "logit")) |>
  tbl_regression(exponentiate = TRUE) |>
  bold_p(t = 0.65)
}
\author{
Daniel D. Sjoberg, Esther Drill
}
