% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n.R
\name{add_n_regression}
\alias{add_n_regression}
\alias{add_n.tbl_regression}
\alias{add_n.tbl_uvregression}
\title{Add N to regression table}
\usage{
\method{add_n}{tbl_regression}(x, location = NULL, ...)

\method{add_n}{tbl_uvregression}(x, location = NULL, ...)
}
\arguments{
\item{x}{a \code{tbl_regression} or \code{tbl_uvregression} table}

\item{location}{location to place Ns. When \code{"label"} total Ns are placed
on each variable's label row. When \code{"level"} level counts are placed on the
variable level for categorical variables, and total N on the variable's label
row for continuous.}

\item{...}{Not used}
}
\description{
Add N to regression table
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/add_n.tbl_regression_ex1.png" alt="image of rendered example table" style="width:64\%;">
}}

\if{html}{Example 2}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/add_n.tbl_regression_ex2.png" alt="image of rendered example table" style="width:64\%;">
}}
}

\examples{
\donttest{
# Example 1 ----------------------------------
add_n.tbl_regression_ex1 <-
  trial \%>\%
  select(response, age, grade) \%>\%
  tbl_uvregression(
    y = response,
    method = glm,
    method.args = list(family = binomial),
    hide_n = TRUE
  ) \%>\%
  add_n(location = "label")

# Example 2 ----------------------------------
add_n.tbl_regression_ex2 <-
  glm(response ~ age + grade, trial, family = binomial) \%>\%
  tbl_regression(exponentiate = TRUE) \%>\%
  add_n(location = "level")
}
}
